from math import isclose

def cross(o, a, b):
    """?????? ????????? ???????? OA x OB (???? ???????? ????)."""
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])

def polygon_area(points):
    """?????? ???????? ?????????? ?????????."""
    n = len(points)
    area = 0
    for i in range(n):
        x1, y1 = points[i]
        x2, y2 = points[(i + 1) % n]
        area += x1 * y2 - y1 * x2
    return abs(area) // 2

def convex_hull(points):
    """????????? ????????? ?????? ????? ??????."""
    points = sorted(points)  # ????????? ?? x, ?? ?? y ??????????
    lower, upper = [], []
    
    for p in points:
        while len(lower) >= 2 and cross(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)
    
    for p in reversed(points):
        while len(upper) >= 2 and cross(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)
    
    return lower[:-1] + upper[:-1]  # ???????? ???? ? ????? ????????, ??? ????????? ??????? ??????

def solve(points):
    """????????? ????????? ???????? ?????????? ?????-???????."""
    # ????????? ?????????? ????????? ??????
    hull = convex_hull(points)
    min_area = float('inf')

    # ???????? ???????? ????? ????? ?? ???????
    for i in range(len(hull)):
        reduced_hull = hull[:i] + hull[i+1:]
        new_hull = convex_hull(reduced_hull)
        min_area = min(min_area, polygon_area(new_hull))
    
    return min_area

# ????
n = int(input())
points = [tuple(map(int, input().split())) for _ in range(n)]

# ??????
print(solve(points))